<?php declare( strict_types=1 );

namespace FernleafSystems\Wordpress\Plugin\Shield\Modules\HackGuard\DB\Malware\Ops;

/**
 * @property string $file_path
 * @property string $file_content
 * @property string $hash_sha256
 * @property string $code_type
 * @property string $sig
 * @property bool   $is_valid_file
 * @property string $malai_status
 * @property int    $last_seen_at
 * @property int    $last_malai_status_at
 */
class Record extends \FernleafSystems\Wordpress\Plugin\Core\Databases\Base\Record {

	public function __get( string $key ) {
		$value = parent::__get( $key );

		switch ( $key ) {
			case 'code_type':
				$value = \strtolower( $value );
				break;
			case 'hash_sha256':
				$value = bin2hex( $value );
				break;
			case 'sig':
			case 'file_content':
				$value = \base64_decode( $value );
				break;
			case 'is_valid_file':
				$value = (bool)$value;
				break;
			case 'malai_status':
				$value = (string)$value;
				break;
			default:
				break;
		}

		return $value;
	}

	public function __set( string $key, $value ) {
		$value = parent::__get( $key );

		switch ( $key ) {
			case 'code_type':
				$value = \strtolower( $value );
				break;
			case 'hash_sha256':
				$value = hex2bin( $value );
				break;
			case 'sig':
			case 'file_content':
				$value = \base64_encode( $value );
				break;
			case 'is_valid_file':
				$value = $value ? 1 : 0;
				break;
			default:
				break;
		}

		parent::__set( $key, $value );
	}
}