<?php declare( strict_types=1 );

namespace FernleafSystems\Wordpress\Plugin\Shield\ActionRouter\Actions\Render\Components\Scans;

use FernleafSystems\Wordpress\Plugin\Shield\ActionRouter\Actions\Traits\SecurityAdminNotRequired;
use FernleafSystems\Wordpress\Services\Services;
use FernleafSystems\Wordpress\Services\Utilities\URL;

class PluginVulnerabilityWarning extends BaseScans {

	use SecurityAdminNotRequired;

	public const SLUG = 'plugin_vulnerability_warning';
	public const TEMPLATE = '/snippets/plugin_vulnerability.twig';

	protected function getRenderData() :array {
		$scanCon = self::con()->getModule_HackGuard()->getScansCon()->WPV();

		$plugin = Services::WpPlugins()->getPluginAsVo( $this->action_data[ 'plugin_file' ] );
		return [
			'strings' => [
				'known_vuln' => sprintf(
					__( '%s has discovered that the currently installed version of the %s plugin has known security vulnerabilities.', 'wp-simple-firewall' ),
					$scanCon->getScanName(), sprintf( '<strong>%s</strong>', $plugin->Name ) ),
				'more_info'  => __( 'More Info', 'wp-simple-firewall' ),
			],
			'flags'   => [
				'has_vulnerabilities' => $scanCon->hasVulnerabilities( $this->action_data[ 'plugin_file' ] )
			],
			'hrefs'   => [
				'vuln_lookup' => URL::Build( 'https://shsec.io/shieldvulnerabilitylookup', [
					'type'    => $plugin->asset_type,
					'slug'    => $plugin->slug,
					'version' => $plugin->Version,
				] ),
			],
			'vars'    => [
				'colspan' => $this->action_data[ 'columns_count' ] ?? 2
			],
		];
	}

	protected function getRequiredDataKeys() :array {
		return [
			'plugin_file'
		];
	}
}